/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.floor;

import java.util.Map;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.assets.model.OverlapType;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;

public class OverlapLayout {
    public static final char NEIGHBOUR_CHARACTER = 'X';
    public static final char EMPTY_CHARACTER = '.';
    private final int id;
    private static final FloorType baseType = new FloorType("Overlap Layout base floor type", -1L, GameMaterialType.OTHER, 0, 1, new OverlapType("temp none"), false, null, null);
    private static final FloorType overlapType = new FloorType("Overlap Layout overlapping floor type", -2L, GameMaterialType.OTHER, 1, 1, new OverlapType("temp organic"), false, null, null);
    private static GameMaterial baseMaterial = new GameMaterial("Unused", -3L, GameMaterialType.OTHER);

    public static OverlapLayout fromNeighbours(TileNeighbours neighbours, FloorType targetType) {
        int layoutId = 0;
        for (Map.Entry entry : neighbours.entrySet()) {
            if (entry.getValue() == null || !((MapTile)entry.getValue()).hasFloor() || ((MapTile)entry.getValue()).getFloor().getFloorType().getFloorTypeId() != targetType.getFloorTypeId()) continue;
            layoutId |= ((CompassDirection)((Object)entry.getKey())).getBinaryMask();
        }
        return new OverlapLayout(layoutId);
    }

    public static OverlapLayout fromString(String diagram) {
        diagram = diagram.replaceAll("\n", "");
        TileNeighbours neighbours = new TileNeighbours();
        for (CompassDirection compassDirection : CompassDirection.values()) {
            neighbours.put(compassDirection, new MapTile(0L, compassDirection.getXOffset(), compassDirection.getYOffset(), baseType, baseMaterial));
            if (!OverlapLayout.overlapAtIndex(compassDirection.getIndex(), diagram)) continue;
            ((MapTile)neighbours.get((Object)compassDirection)).getFloor().setFloorType(overlapType);
            ((MapTile)neighbours.get((Object)compassDirection)).getFloor().setMaterial(baseMaterial);
        }
        return OverlapLayout.fromNeighbours(neighbours, overlapType);
    }

    private static boolean overlapAtIndex(int index, String diagram) {
        return diagram.charAt(index) == 'X';
    }

    public OverlapLayout(int id) {
        this.id = id;
    }

    public OverlapLayout reduceToMeaningfulForm() {
        char[] characters = this.toString().replaceAll("\n", "").toCharArray();
        this.ignoreCornerIfEitherSiblingIsSet(characters, CompassDirection.NORTH_WEST, CompassDirection.NORTH, CompassDirection.WEST);
        this.ignoreCornerIfEitherSiblingIsSet(characters, CompassDirection.NORTH_EAST, CompassDirection.NORTH, CompassDirection.EAST);
        this.ignoreCornerIfEitherSiblingIsSet(characters, CompassDirection.SOUTH_WEST, CompassDirection.SOUTH, CompassDirection.WEST);
        this.ignoreCornerIfEitherSiblingIsSet(characters, CompassDirection.SOUTH_EAST, CompassDirection.SOUTH, CompassDirection.EAST);
        return OverlapLayout.fromString(String.valueOf(characters));
    }

    public OverlapLayout flipX() {
        char[] original = this.toString().replaceAll("\n", "").toCharArray();
        char[] flipped = (char[])original.clone();
        flipped[CompassDirection.NORTH_WEST.getIndex()] = original[CompassDirection.NORTH_EAST.getIndex()];
        flipped[CompassDirection.NORTH_EAST.getIndex()] = original[CompassDirection.NORTH_WEST.getIndex()];
        flipped[CompassDirection.WEST.getIndex()] = original[CompassDirection.EAST.getIndex()];
        flipped[CompassDirection.EAST.getIndex()] = original[CompassDirection.WEST.getIndex()];
        flipped[CompassDirection.SOUTH_WEST.getIndex()] = original[CompassDirection.SOUTH_EAST.getIndex()];
        flipped[CompassDirection.SOUTH_EAST.getIndex()] = original[CompassDirection.SOUTH_WEST.getIndex()];
        return OverlapLayout.fromString(String.valueOf(flipped));
    }

    public OverlapLayout flipY() {
        char[] original = this.toString().replaceAll("\n", "").toCharArray();
        char[] flipped = (char[])original.clone();
        flipped[CompassDirection.NORTH_WEST.getIndex()] = original[CompassDirection.SOUTH_WEST.getIndex()];
        flipped[CompassDirection.NORTH_EAST.getIndex()] = original[CompassDirection.SOUTH_EAST.getIndex()];
        flipped[CompassDirection.NORTH.getIndex()] = original[CompassDirection.SOUTH.getIndex()];
        flipped[CompassDirection.SOUTH.getIndex()] = original[CompassDirection.NORTH.getIndex()];
        flipped[CompassDirection.SOUTH_WEST.getIndex()] = original[CompassDirection.NORTH_WEST.getIndex()];
        flipped[CompassDirection.SOUTH_EAST.getIndex()] = original[CompassDirection.NORTH_EAST.getIndex()];
        return OverlapLayout.fromString(String.valueOf(flipped));
    }

    private void ignoreCornerIfEitherSiblingIsSet(char[] characters, CompassDirection corner, CompassDirection sibling1, CompassDirection sibling2) {
        if (characters[sibling1.getIndex()] == 'X' || characters[sibling2.getIndex()] == 'X') {
            characters[corner.getIndex()] = 46;
        }
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.topRow() + "\n" + this.middleRow() + "\n" + this.bottomRow();
    }

    private StringBuilder addNeighbourCharacterIf(boolean isNeighbour, StringBuilder builder) {
        if (isNeighbour) {
            builder.append('X');
        } else {
            builder.append('.');
        }
        return builder;
    }

    private boolean neighbourInDirection(CompassDirection direction) {
        return (this.id & direction.getBinaryMask()) > 0;
    }

    public String topRow() {
        StringBuilder row = new StringBuilder();
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.NORTH_WEST), row);
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.NORTH), row);
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.NORTH_EAST), row);
        return row.toString();
    }

    public String middleRow() {
        StringBuilder row = new StringBuilder();
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.WEST), row);
        row.append('.');
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.EAST), row);
        return row.toString();
    }

    public String bottomRow() {
        StringBuilder row = new StringBuilder();
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.SOUTH_WEST), row);
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.SOUTH), row);
        this.addNeighbourCharacterIf(this.neighbourInDirection(CompassDirection.SOUTH_EAST), row);
        return row.toString();
    }
}

